import { RefForwardingComponent, ReactChild } from "react";
declare type ToggleSwitchProps = {
    /** Give an id so that your onChange listener can tell you which field is the currently checked one. */
    id: string;
    /** Labels can be either strings or JSX */
    label: ReactChild;
} & JSX.IntrinsicElements["input"];
/**
 * Toggle switches provide the same functionality as checkboxes but are more widely used in mobile environments.
 */
declare const ToggleSwitch: RefForwardingComponent<HTMLInputElement, ToggleSwitchProps>;
export { ToggleSwitch };
