import { Component, RefObject, ReactNode } from "react";
declare type StepperProps = {
    id: string;
    errorMessage?: string;
    defaultValue?: string;
    label: ReactNode;
    helperText?: string;
    valid?: boolean;
    inputRef?: RefObject<HTMLInputElement>;
    /** How much a number gets increased or decreased with each click */
    step?: number;
    /** The minimum value a user can set.
     *
     * **Caution**: Using this alongside `step` has an influence on the values that can be set. For example, setting a min of 2 and a step of 3 requires all values to be a result of `min + step * n = 2 + 3 * n`. */
    min?: number;
    max?: number;
    onChange?: ((this: Window, ev: Event) => unknown) | null;
} & Omit<JSX.IntrinsicElements["input"], "children" | "type">;
declare type StepperState = {
    ref: RefObject<HTMLInputElement>;
};
declare class Stepper extends Component<StepperProps, StepperState> {
    static defaultProps: {
        min: number;
        max: number;
        step: number;
        defaultValue: number;
    };
    constructor(props: any);
    /** Special treatment for IE11 because it does support stepUp and stepDown for type="number". However, these are supported for type="range". Knowing this, we can cheat our way towards having native stepUp and stepDown functionality.
     */
    private stepWithIE11Compatibility;
    render(): JSX.Element;
}
export { Stepper };
