import { Component, ReactNode } from "react";
import PropTypes from "prop-types";
declare type SliderProps = {
    id: string;
    label?: ReactNode;
    /** Title property is used in the accessibility labels to describe the purpose of the slider for visually impaired users */
    title: string;
    /** maxValue is use to update the max range limiter */
    maxValue: number;
    /** minValue is use to update the min range limiter. If no value is given the limiter will be hidden */
    minValue?: number;
    min: number;
    max: number;
    step?: number;
    onChange?: (maxValue: number, minValue: number) => void;
    onDrag?: (maxValue: number, minValue: number) => void;
    onRelease?: (maxValue: number, minValue: number) => void;
    tooltip?: (value: number) => string | ReactNode;
};
declare class Slider extends Component<SliderProps> {
    private sliderContainerRef;
    private draggedLimiter;
    private limiters;
    static propTypes: {
        maxValue: PropTypes.Requireable<number>;
        minValue: PropTypes.Requireable<number>;
    };
    private startOffset;
    private startValue;
    static defaultProps: {
        step: number;
    };
    state: {
        isDragging: boolean;
        max: {
            value: number;
            viewValue: number;
            valueMax: number;
            valueMin: number;
        };
        min: {
            value: number;
            viewValue: number;
            valueMax: any;
            valueMin: number;
        };
    };
    componentDidMount(): void;
    componentDidUpdate(prevProps: Readonly<SliderProps>, prevState: any): void;
    private getLabelId;
    private getValueOfDraggedButton;
    private hasMinLimiter;
    private onDrag;
    private onRelease;
    private getViewValue;
    private getXPosition;
    private setMaxValue;
    private setMinValue;
    private getSnapValue;
    private onMove;
    private bindHandlerEvents;
    private isMaxButtonDragged;
    private bindMoveEvents;
    private unbindMoveEvents;
    private getRangePosition;
    private renderLimiter;
    private getTooltipValue;
    render(): JSX.Element;
}
export { Slider };
