import { Component, ReactNode } from "react";
declare type TabsProps = {
    defaultSelected?: number;
    children: ReactNode;
    onClick?: Function;
};
/** Relates to: https://www.w3.org/TR/wai-aria-practices/examples/tabs/tabs-1/tabs.html */
declare class TabsContainer extends Component<TabsProps, {}> {
    private tabList;
    private tabs;
    private tabPanels;
    private tabFocus;
    private ref;
    componentDidMount(): void;
    componentWillUnmount(): void;
    private removeEventListeners;
    private addEventListeners;
    private changeTab;
    private changePanel;
    private handleTabClick;
    /**
     *  The tabindex applies only to the active tab and his tabpanel to tab from the active button to the content
     *  Other tabs are not tabbable (-1) and are reachable by the arrow keys
     */
    private handleTabListKey;
    private linkTabsWithPanels;
    render(): JSX.Element;
}
export { TabsContainer };
