import { ReactChild, RefForwardingComponent } from "react";
declare type TextInputProps = {
    /** Give an id so that the label can properly assigned to the input field. */
    id: string;
    /** A placeholder inside the input field that is only shown when the input field is empty. */
    placeholder: string;
    /** To provide user feedback underneath the input field why the input is invalid. */
    errorMessage?: string;
    /** Labels can be either strings or JSX */
    label: ReactChild;
    /** To provide additional information underneath the input field. */
    helperText?: string;
    /** Should the input field render in error state with error message? */
    valid?: boolean;
    /** Should the input field render in success state? */
    success?: boolean;
    /** Render an affix container (containing an icon or a unit) on the left side. */
    affixLeft?: "none" | "unit" | "icon";
    /** Which unit should be rendered in the left affix container? (affixLeft required) */
    unitLeft?: "none" | "percent" | "sqm" | "eur" | "eurPerSqm" | "years" | "months";
    /** Which icon should be rendered in the left affix container? <is24-icon-class-name> (affixLeft required) */
    iconLeft?: string;
    /** Render an affix container (containing an icon or a unit) on the right side. */
    affixRight?: "none" | "unit" | "icon";
    /** Which unit should be rendered in the right affix container? (affixRight required) */
    unitRight?: "none" | "percent" | "sqm" | "eur" | "eurPerSqm" | "years" | "months";
    /** Which icon should be rendered in the right affix container? <is24-icon-class-name> (affixRight required) */
    iconRight?: string;
    /** Signify that field is required, and add suffix to input label */
    mandatory?: boolean;
} & Omit<JSX.IntrinsicElements["input"], "children">;
declare const TextInput: RefForwardingComponent<HTMLInputElement, TextInputProps>;
export { TextInput };
