import { RefForwardingComponent, ReactChild } from "react";
declare type RadioButtonProps = {
    /** Give an id so that your onChange listener can tell you which field is the currently checked one. */
    id: string;
    /** Labels can be either strings or JSX */
    label: ReactChild;
    /** Provide a name so that radio buttons can form a group. All radio buttons in a group have to share the same name. */
    name: string;
    isErroneous?: boolean;
} & JSX.IntrinsicElements["input"];
declare const RadioButton: RefForwardingComponent<HTMLInputElement, RadioButtonProps>;
export { RadioButton };
