import { RefForwardingComponent } from "react";
declare type ButtonProps = {
    appearance?: "primary" | "secondary" | "tertiary" | "ghost" | "inverted";
    iconStandalone?: boolean;
    textStyle?: boolean;
    size?: "small" | "medium" | "large";
    renderContainer?: (props: any) => JSX.Element;
} & JSX.IntrinsicElements["button"];
/**
 * Buttons communicate actions that users can take. They allow users to make choices with one single tap.
 *
 * Each button should have a proper label and, optionally, an icon. The meaning should be clear and always tie back to what it will do for the user because users feel more comfortable when they understand what action a button does. Tell users what the outcome will be after pressing the button. Such explicit labeling serves as just-in-time help, giving users confidence in selecting the action.
 */
declare const Button: RefForwardingComponent<HTMLButtonElement, ButtonProps>;
export { Button };
