import { FC } from "react";
declare type TooltipProps = {
    /** Class property goes directly in tooltip's root div. */
    className?: string;
    /** The position of tooltip itself in relation to target element. */
    bodyPosition?: "top" | "right" | "bottom" | "left";
    /** The position of tooltip's arrow along the edge. (!)Only for bottom and top positioning! */
    arrowPosition?: "left" | "center" | "right";
} & JSX.IntrinsicElements["div"];
/**
 * Tooltips can be used to provide more or specific information and can contain everything from strings to whole forms with CTAs.
 */
declare const Tooltip: FC<TooltipProps>;
export { Tooltip };
