declare type PagerOptions = {
    displayPages: number;
    maxPages: number;
};
declare type PaginateOptions = {
    pages: number;
    current: number;
};
declare type PaginateUi = {
    from?: number;
    to?: number;
    page: number;
};
declare type PaginateResult = {
    ui: PaginateUi[];
    prev: number | null;
    next: number | null;
    total: number;
};
declare const newPager: {
    (options: PagerOptions): {
        paginate: ({ pages, current }: PaginateOptions) => PaginateResult;
    };
    __docgenInfo: {
        tags: {};
        description: string;
        displayName: string;
        methods: any[];
        props: {
            displayPages: {
                defaultValue: any;
                description: string;
                name: string;
                declarations: {
                    fileName: string;
                    name: string;
                }[];
                required: boolean;
                type: {
                    name: string;
                };
            };
            maxPages: {
                defaultValue: any;
                description: string;
                name: string;
                declarations: {
                    fileName: string;
                    name: string;
                }[];
                required: boolean;
                type: {
                    name: string;
                };
            };
        };
    };
};
export { newPager };
export type { PaginateUi, PaginateResult };
