import { FC } from "react";
declare type IndicatorProps = {
    className?: string;
    expanded?: boolean;
    float?: boolean;
    appearance: "dot" | "numeric" | "label" | "tag" | "brand";
} & JSX.IntrinsicElements["div"];
/**
 * Indicators are visual indicators to emphasize an information. Visual indicators are used to make certain items stand out from the crowd.
 * They don't require the user to take action, but act as communication tools to cue something noteworthy.
 * Indicators are not always present but appear under certain conditions.
 *
 * A badge is a quick visual indicator like a dot on top of an icon or other elements.
 *
 * A numeric-badge is a quick visual indicator for a numeric value either next to an element or inside the element itself.
 *
 * A label is a visual indicator for a specific characteristic of an element. A label wants to highlight a unique property of an element. They are actionless.
 *
 * Tags and Tags with a cross represent a number of characteristics of an object and/or a category of an object. The only difference between these two elements is that tags are not clickable by default, but tags with a cross icon are.
 */
declare const Indicator: FC<IndicatorProps>;
export { Indicator };
