import { Component, RefObject, ReactChild } from "react";
declare type DatePickerProps = {
    id: string;
    headline?: string;
    subheadline?: string;
    initialDisplayedMonth?: Date;
    preselectedDate?: Date;
    preselectedEndDate?: Date;
    /** Labels can be either strings or JSX */
    label?: ReactChild;
    placeholder?: string;
    daterange?: boolean;
    locale?: "de-DE" | "en-US" | "en-GB";
    ariaLabelNextMonth?: string;
    ariaLabelPreviousMonth?: string;
    inputProps?: Omit<JSX.IntrinsicElements["input"], "ref">;
    inputRef?: RefObject<HTMLInputElement>;
    cancelButtonClassName?: string;
    okButtonClassName?: string;
};
declare type DatePickerState = {
    displayedMonth: Date;
    isDatePickerModalVisible: boolean;
    selectedStartDate: Date;
    selectedEndDate: Date;
    today: Date;
    wrongDate: boolean;
    selectingStartDate: boolean;
};
declare class DatePicker extends Component<DatePickerProps, DatePickerState> {
    private selectedStartDateUponOpeningModal;
    private selectedEndDateUponOpeningModal;
    private dateInputField;
    private monthField;
    static defaultProps: {
        label: string;
        placeholder: string;
        daterange: boolean;
        locale: string;
        ariaLabelNextMonth: string;
        ariaLabelPreviousMonth: string;
    };
    constructor(props: any);
    private keyboardListener;
    componentDidMount(): void;
    componentWillUnmount(): void;
    private openDatePickerModal;
    private closeDatePickerModal;
    private cancel;
    private nextMonth;
    private previousMonth;
    private changeMonth;
    private selectDate;
    private handleDateFieldInput;
    private getDatePickerDayCell;
    render(): JSX.Element;
}
export { DatePicker };
