import React, { HTMLProps, ReactChild } from "react";
declare class TextInput extends React.Component<{
    initialValue?: string;
    placeholder: string;
    className?: string;
    disabled?: boolean;
    errorMessage?: string;
    initialValid?: boolean;
    showValidityBeforeInteraction?: boolean;
    /** Whether the input field should turn red and the error message should be shown on invalid input */
    highlightValidity: boolean;
    /** Labels can be either strings or JSX */
    label: ReactChild;
    helperText?: string;
    type?: string;
    iconLeft?: string;
    iconRight?: string;
    otherProps: HTMLProps<HTMLInputElement>;
    onValidate?: (value: string) => boolean;
    onFocus?: (value: string, valid: boolean) => void;
    onChange?: (value: string, valid: boolean) => void;
    onBlur?: (value: string, valid: boolean) => void;
}, {
    valid: boolean;
    highlightValidation: boolean;
}> {
    static defaultProps: {
        initialValue: string;
        placeholder: string;
        className: string;
        disabled: boolean;
        errorMessage: string;
        initialValid: any;
        showValidityBeforeInteraction: boolean;
        highlightValidity: boolean;
        inputProps: {};
        label: string;
        helperText: string;
        type: string;
        iconLeft: string;
        iconRight: string;
        otherProps: {};
        onValidate: () => boolean;
        onFocus: () => void;
        onChange: () => void;
        onBlur: () => void;
    };
    private inputID;
    constructor(props: any);
    private onFocus;
    private onChange;
    private onBlur;
    render(): JSX.Element;
}
export { TextInput };
