import { FC, ReactChild } from "react";
declare type RadioButtonProps = {
    /** Give an id so that your onChange listener can tell you which field is the currently checked one. */
    id: string;
    /** Labels can be either strings or JSX */
    label: ReactChild;
    /** Provide a name so that radio buttons can form a group. All radio buttons in a group have to share the same name. */
    groupName: string;
    defaultChecked?: boolean;
    disabled?: boolean;
    className?: string;
    isErroneous?: boolean;
    "aria-label"?: string;
};
declare const RadioButton: FC<RadioButtonProps>;
export { RadioButton };
