import { ChangeEvent, FC } from "react";
declare type ToggleSwitchProps = {
    /** Give an id so that your onChange listener can tell you which field is the currently checked one. */
    id: string;
    label: string;
    defaultChecked?: boolean;
    disabled?: boolean;
    "aria-label"?: string;
    onChange?: (event: ChangeEvent) => void;
};
/**
 * Toggle switches provide the same functionality as checkboxes but are more widely used in mobile environments.
 */
declare const ToggleSwitch: FC<ToggleSwitchProps>;
export { ToggleSwitch };
