import { Component, HTMLProps } from "react";
/**
 * SelectFields are straightforward to create. If you want to listen to changes, you can do so via the \`onFocus\`, \`onBlur\`, and \`onChange\` events which all get (value, valid) as input parameters.
 */
declare class SelectField extends Component<{
    initialValue?: string;
    className?: string;
    disabled?: boolean;
    isErroneous?: boolean;
    errorMessage?: string;
    otherProps?: HTMLProps<HTMLSelectElement>;
    label: string;
    helperText?: string;
    iconLeft?: string;
    options: {
        value: string;
        label: string;
    }[];
    dropdownLink: boolean;
    dropdownLinkIconOnly: boolean;
    dropdownLinkNoTextOnMobile: boolean;
    "aria-label"?: string;
    onFocus?: (value: string) => void;
    onChange?: (value: string) => void;
    onBlur?: (value: string) => void;
}, {
    value: string;
}> {
    static defaultProps: {
        initialValue: string;
        className: string;
        disabled: boolean;
        isErroneous: boolean;
        errorMessage: string;
        otherProps: {};
        label: string;
        helperText: string;
        iconLeft: string;
        options: any[];
        dropdownLink: boolean;
        dropdownLinkIconOnly: boolean;
        dropdownLinkNoTextOnMobile: boolean;
        onFocus: () => void;
        onChange: () => void;
        onBlur: () => void;
    };
    private inputID;
    constructor(props: any);
    private onFocus;
    private onChange;
    private onBlur;
    render(): JSX.Element;
}
export { SelectField };
