import React, { Component, DetailedHTMLProps, ButtonHTMLAttributes } from "react";
declare enum typeOfButton {
    primary = "primary",
    secondary = "secondary",
    ghost = "ghost"
}
/**
 * Buttons communicate actions that users can take. They allow users to make choices with one single tap.
 *
 * Each button should have a proper label and, optionally, an icon. The meaning should be clear and always tie back to what it will do for the user because users feel more comfortable when they understand what action a button does. Tell users what the outcome will be after pressing the button. Such explicit labeling serves as just-in-time help, giving users confidence in selecting the action.
 */
declare class Button extends Component<{
    type?: typeOfButton;
    bigSize?: boolean;
    disabled?: boolean;
    iconStandalone?: boolean;
    textStyle?: boolean;
    className?: string;
    "aria-label"?: string;
    otherProps?: DetailedHTMLProps<ButtonHTMLAttributes<HTMLButtonElement>, HTMLButtonElement>;
    onClick?: (event: React.MouseEvent) => void;
}, {}> {
    static defaultProps: {
        type: typeOfButton;
        bigSize: boolean;
        disabled: boolean;
        textStyle: boolean;
        otherProps: {};
        className: string;
    };
    static typeOfButtonEnum: typeof typeOfButton;
    constructor(props: any);
    private getButtonClassName;
    render(): JSX.Element;
}
export { Button };
